# MAF Gateway App

A Laravel application with React, Inertia.js, Tailwind CSS, and Storybook.

## Tech Stack

- **Backend**: Laravel 12
- **Frontend**: React 19 with Inertia.js
- **Styling**: Tailwind CSS v4
- **Build Tool**: Vite 7
- **Package Manager**: pnpm
- **Component Development**: Storybook 10

## Prerequisites

- PHP 8.2 or higher
- Composer
- Node.js (v18 or higher)
- pnpm
- SQLite (or MySQL/PostgreSQL)

## Installation

### 1. Install PHP Dependencies

```bash
composer install
```

### 2. Install Node Dependencies

```bash
pnpm install
```

### 3. Environment Setup

```bash
# Copy environment file
cp .env.example .env

# Generate application key
php artisan key:generate
```

### 4. Database Setup

```bash
# Run migrations
php artisan migrate

# (Optional) Seed the database
php artisan db:seed
```

## Running the Application

### Development Mode

#### Option 1: Run Laravel and Vite separately (Recommended)

**Terminal 1 - Laravel Server:**
```bash
php artisan serve
```

**Terminal 2 - Vite Dev Server:**
```bash
pnpm dev
```

The application will be available at `http://localhost:8000`

#### Option 2: Run everything with Composer script

```bash
composer dev
```

This runs Laravel server, queue worker, logs, and Vite concurrently.

### Production Build

```bash
# Build assets for production
pnpm build
```

## Storybook

### Start Storybook Development Server

```bash
pnpm storybook
```

Storybook will be available at `http://localhost:6006`

### Build Storybook for Production

```bash
pnpm build-storybook
```

## Common Commands

### Laravel Commands

```bash
# Clear application cache
php artisan cache:clear

# Clear configuration cache
php artisan config:clear

# Clear route cache
php artisan route:clear

# Clear view cache
php artisan view:clear

# Run database migrations
php artisan migrate

# Rollback last migration
php artisan migrate:rollback

# Create a new migration
php artisan make:migration create_table_name

# Create a new model
php artisan make:model ModelName

# Create a new controller
php artisan make:controller ControllerName

# Run tests
php artisan test
```

### Frontend Commands

```bash
# Install dependencies
pnpm install

# Run development server
pnpm dev

# Build for production
pnpm build

# Start Storybook
pnpm storybook

# Build Storybook
pnpm build-storybook
```

## Project Structure

```
├── app/                    # Laravel application code
│   ├── Http/
│   │   ├── Controllers/    # Controllers
│   │   └── Middleware/     # Middleware
│   └── Models/             # Eloquent models
├── resources/
│   ├── css/                # CSS files
│   ├── js/                 # JavaScript/React files
│   │   └── components/     # React components
│   └── views/              # Blade templates
├── routes/                 # Route definitions
├── database/               # Migrations, seeders, factories
├── .storybook/            # Storybook configuration
└── public/                # Public assets
```

## Development Workflow

1. Start the Laravel server: `php artisan serve`
2. Start Vite dev server: `pnpm dev`
3. Start Storybook (optional): `pnpm storybook`
4. Make changes to your code
5. Changes will be hot-reloaded automatically

## Troubleshooting

### Clear all caches
```bash
php artisan optimize:clear
```

### Reinstall dependencies
```bash
# PHP dependencies
composer install

# Node dependencies
rm -rf node_modules
pnpm install
```

### Permission issues
```bash
chmod -R 775 storage bootstrap/cache
```

## License

The Laravel framework is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).
