import NavMenu from './navMenu';

export default function header({navItems}){
    return(
            <header className="sticky top-0 z-50 bg-white/80 backdrop-blur border-b border-gray-200">
            <div className="max-w-7xl mx-auto px-6">
                <div className="flex items-center justify-between h-16">

                {/* Logo */}
                <div className="flex items-center gap-2">
                    <div className="h-9 w-9 rounded-lg bg-gradient-to-br from-indigo-500 to-purple-600 flex items-center justify-center text-white font-bold">
                    C
                    </div>
                    <span className="text-xl font-semibold bg-gradient-to-r from-indigo-600 to-purple-600 bg-clip-text text-transparent">
                    Compliance Suite
                    </span>
                </div>

                {/* Desktop Nav */}
                <NavMenu navItems={navItems} />

                {/* Actions */}
                <div className="flex items-center gap-4">
                    <button className="hidden md:inline text-gray-600 hover:text-indigo-600 transition">
                    Login
                    </button>
                    <button className="px-4 py-2 rounded-lg bg-indigo-600 text-white text-sm font-medium hover:bg-indigo-700 transition shadow-sm">
                    Get Started
                    </button>
                </div>
                </div>
            </div>
        </header>
    );
}