# Hot Reload Setup

## Quick Start for Hot Reload

1. **Terminal 1 - Start Laravel:**
   ```bash
   php artisan serve
   ```

2. **Terminal 2 - Start Vite Dev Server:**
   ```bash
   pnpm dev
   ```

3. **Open browser:** `http://localhost:8000`

## How It Works

- When `pnpm dev` is running, it creates a `public/hot` file
- Laravel detects this file and uses the Vite dev server instead of built assets
- Changes to `.jsx`, `.js`, `.css` files will automatically reload in the browser
- No need to rebuild or refresh manually!

## To Stop Hot Reload

- Stop the `pnpm dev` process (Ctrl+C)
- Laravel will automatically fall back to built assets

## Troubleshooting

If hot reload stops working:
1. Stop `pnpm dev` (Ctrl+C)
2. Remove `public/hot` file: `rm public/hot`
3. Restart: `pnpm dev`

