import "./bootstrap";
import "../css/app.css";
import React from "react";
import { createRoot } from "react-dom/client";
import { createInertiaApp, router } from "@inertiajs/react";
import { resolvePageComponent } from "laravel-vite-plugin/inertia-helpers";

const appName = import.meta.env.VITE_APP_NAME || "Laravel";

createInertiaApp({
    title: (title) => `${appName} | ${title}`,
    resolve: (name) =>
        resolvePageComponent(
            `./Pages/${name}.jsx`,
            import.meta.glob("./Pages/**/*.jsx")
        ),
    setup({ el, App, props }) {
        const root = createRoot(el);

        root.render(<App {...props} />);
    },
    progress: {
        color: "#4B5563",
    },
});

router.on("error", (event) => {
    if (event.detail.response) {
        const status = event.detail.response.status;

        // Handle 419 (Session Expired) - let the backend handle it
        if (status === 419) {
            // Don't prevent default - let Inertia handle the response
            return;
        }

        // Handle 405 (Method Not Allowed) - redirect to login
        if (status === 405) {
            window.location.href = "/login";
            return false;
        }
    }
});
