import React from 'react';

export const Button = ({ 
  primary = false, 
  size = 'medium', 
  backgroundColor,
  label, 
  ...props 
}) => {
  const mode = primary 
    ? 'bg-blue-600 text-white hover:bg-blue-700' 
    : 'bg-gray-200 text-gray-900 hover:bg-gray-300';
  
  const sizeClasses = {
    small: 'px-3 py-1.5 text-sm',
    medium: 'px-4 py-2 text-base',
    large: 'px-6 py-3 text-lg',
  };

  return (
    <button
      type="button"
      className={`
        font-semibold rounded-lg transition-colors
        ${mode}
        ${sizeClasses[size]}
      `}
      style={{ backgroundColor }}
      {...props}
    >
      {label}
    </button>
  );
};

