import { defineConfig } from "vite";
import laravel from "laravel-vite-plugin";
import react from "@vitejs/plugin-react";
import tailwindcss from "@tailwindcss/vite";

export default defineConfig({
    plugins: [
        laravel({
            input: ["resources/js/app.jsx"],
            refresh: true,
        }),
        react(),
        tailwindcss(),
    ],
    server: {
        cors: {
            origin: "*",
        },
        hmr: {
            overlay: false,
        },
        watch: {
            // Ignore layout-specific files to prevent conflicts
            ignored: [
                "**/resources/js/layout.jsx",
                "**/resources/css/layout.css",
                "**/resources/js/Pages/Layout/**",
                "**/resources/js/components/layout/**",
            ],
        },
    },
    optimizeDeps: {
        include: ["react", "react-dom"],
    },
});
