import { Picker } from '@react-native-picker/picker';
import React from 'react';
import { StyleSheet, Text, TouchableOpacity, View } from 'react-native';

interface GroupItem {
  key: string;
  title: string;
}

interface FilterComponentProps {
  groupData: GroupItem[];
  selectedGroup: string;
  setGroup: (value: string) => void;
  filter: string;
  setFilter: (value: string) => void;
  actionPlanToggle: () => void;
  isActionplan: boolean;
}

const FilterComponent: React.FC<FilterComponentProps> = ({
  groupData,
  selectedGroup,
  setGroup,
  filter,
  setFilter,
  actionPlanToggle,
  isActionplan,
}) => {
  return (
    <View style={{ backgroundColor: '#ECECEC', marginHorizontal: 8, height: 115 }}>
      <View style={styles.header}>
        <View style={styles.answerPicker}>
          <Picker
            selectedValue={filter}
            onValueChange={(value) => setFilter(value)}
            style={{ color: '#9B9B9B', fontSize: 12 }}
            dropdownIconColor="#9B9B9B"
          >
            <Picker.Item label="View All" value="ViewAll" />
            <Picker.Item label="Unanswered" value="unanswered" />
          </Picker>
        </View>

        <TouchableOpacity
          style={[styles.actionPlan, { backgroundColor: isActionplan ? '#1BD7A4' : 'white' }]}
          onPress={actionPlanToggle}
        >
          <Text style={{ color: isActionplan ? 'white' : 'gray', fontSize: 12 }}>ACTION PLAN</Text>
        </TouchableOpacity>
      </View>

      <View style={styles.groupPicker}>
        <Picker
          selectedValue={selectedGroup}
          onValueChange={(value) => setGroup(value)}
          style={{ color: '#9B9B9B', fontSize: 12 }}
          dropdownIconColor="#9B9B9B"
        >
          <Picker.Item label="All" value="" />
          {groupData.map((item, i) => (
            <Picker.Item key={i} label={item.title} value={item.key} />
          ))}
        </Picker>
      </View>
    </View>
  );
};

export { FilterComponent };

const styles = StyleSheet.create({
  answerPicker: {
    borderWidth: 1,
    width: '45%',
    marginRight: 4,
    backgroundColor: 'white',
    borderColor: '#ECECEC',
    borderRadius: 8,
    justifyContent: 'center',
    height: 40,
  },
  actionPlan: {
    width: 150,
    flex: 2,
    marginLeft: 8,
    alignItems: 'center',
    borderRadius: 8,
    justifyContent: 'center',
  },
  groupPicker: {
    borderWidth: 1,
    backgroundColor: 'white',
    borderColor: '#ECECEC',
    borderRadius: 8,
    justifyContent: 'center',
    marginHorizontal: 8,
    height: 40,
  },
  header: {
    flexDirection: 'row',
    margin: 8,
    marginTop: 14,
  },
});
