import { MaterialIcons } from '@expo/vector-icons';
import { Box, HStack, Icon, Pressable, Text } from 'native-base';
import React from 'react';
import { FlatList } from 'react-native';
import Colors from '../../constants/colors';

interface ListItemData {
  form_id: string | number;
  id: string | number;
  technical_form_id?: string | number;
  operational_form_id?: string | number;
  selectedEntity?: string;
  selectedGroup?: string;
  type?: string;
  checklistSubmissionId?: string | number;
  selectedBUManager?: string;
  title: string;
}

interface ListComponentProps {
  data: ListItemData[];
  listClick: (
    form_id: string | number,
    id: string | number,
    technical_form_id?: string | number,
    operational_form_id?: string | number,
    selectedEntity?: string,
    selectedGroup?: string,
    type?: string,
    checklistSubmissionId?: string | number,
    selectedBUManager?: string
  ) => void;
  onDelete: (
    form_id: string | number,
    id: string | number,
    technical_form_id?: string | number,
    operational_form_id?: string | number,
    selectedEntity?: string,
    selectedGroup?: string
  ) => void;
}

export const ListComponent: React.FC<ListComponentProps> = ({ data, listClick, onDelete }) => {
  const renderItem = ({ item }: { item: ListItemData }) => {
    const isDraft = item.title.includes(' [draft]');
    const displayTitle = item.title.replace(' [draft]', '');

    return (
      <Box borderBottomWidth={1} borderColor="#ECECEC" py={2} px={3}>
        <HStack alignItems="center" justifyContent="space-between">
          <HStack alignItems="center">
            {isDraft && (
              <Pressable
                onPress={() =>
                  onDelete(
                    item.form_id,
                    item.id,
                    item.technical_form_id,
                    item.operational_form_id,
                    item.selectedEntity,
                    item.selectedGroup
                  )
                }
                mr={3}
              >
                <Icon as={MaterialIcons} name="delete" size={5} color={Colors.colorTextInput} />
              </Pressable>
            )}

            <Pressable
              onPress={() =>
                listClick(
                  item.form_id,
                  item.id,
                  item.technical_form_id,
                  item.operational_form_id,
                  item.selectedEntity,
                  item.selectedGroup,
                  item.type,
                  item.checklistSubmissionId,
                  item.selectedBUManager
                )
              }
            >
              <Text color={Colors.colorTextInput}>{displayTitle}</Text>
            </Pressable>
          </HStack>

          <Icon as={MaterialIcons} name="arrow-forward-ios" size={5} color={Colors.colorTextInput} />
        </HStack>
      </Box>
    );
  };

  return <FlatList data={data} renderItem={renderItem} keyExtractor={(item, index) => `${item.id}-${index}`} />;
};
