import { Dispatch } from "redux";
import {
    HISTORY_ADD,
    HISTORY_REMOVE,
} from "./types";

/**
 * Remove history by id
 */
export const removeHistoryById = (id: string) => {
  return (dispatch: Dispatch) => {
    dispatch({
      type: HISTORY_REMOVE,
      payload: { id },
    });
  };
};

/**
 * Add a new history record
 */
export const addHistory = (formData: {
  title: string;
  data: any;
  url: string;
}) => {
  return (dispatch: Dispatch) => {
    const { title, data, url } = formData;

    dispatch({
      type: HISTORY_ADD,
      payload: { title, data, url },
    });
  };
};
