import { AnyAction } from "redux";
import { ThunkAction, ThunkDispatch } from "redux-thunk";
import { RootState } from "../store";
import { DRAFT_ANSWERS, REMOVE_DRAFT_ANSWERS } from "./types";

// Thunk Type
type AppThunk<ReturnType = void> = ThunkAction<ReturnType, RootState, unknown, AnyAction>;

/**
 * Save draft answers for a form
 */
export const draftAnswer = (
  draftValues: any,
  formId: string,
  type: string,
  selectedEntity: string,
  selectedGroup: string,
  checklistSubmissionId?: string,
  score?: number,
  selectedBUManager?: string
): AppThunk => {
  return (dispatch: ThunkDispatch<RootState, unknown, AnyAction>) => {
    dispatch({
      type: DRAFT_ANSWERS,
      payload: [
        {
          score,
          draftValues,
          formId,
          type,
          selectedEntity,
          selectedGroup,
          checklistSubmissionId,
          selectedBUManager,
        },
      ],
    });
  };
};

/**
 * Remove draft answers for a submitted form
 */
export const removeSubmittedFormDraft = (
  formId: string,
  selectedEntity: string
): AppThunk => {
  return (dispatch: ThunkDispatch<RootState, unknown, AnyAction>) => {
    dispatch({
      type: REMOVE_DRAFT_ANSWERS,
      payload: { formId, selectedEntity },
    });
  };
};
