import axios, { AxiosResponse } from "axios";
import { Dispatch } from "redux";

// Define a generic type for your data payload
export const submitData = <T = any>(
  url: string,
  data: T
) => {
  return async (dispatch: Dispatch): Promise<AxiosResponse<any>> => {
    try {
      const response = await axios.post(url, data, {
        timeout: 420_000, // 7 minutes
      });
      return response;
    } catch (error: unknown) {
      console.error("submitData error:", error);
      throw error;
    }
  };
};
