import React, { useState } from "react";
import { Dimensions, StyleSheet, Text, TouchableOpacity, View } from "react-native";
import * as Progress from "react-native-progress";
import Colors from "../../constants/colors";

const { width } = Dimensions.get("window");

interface BottomButtonProps {
  pressCallBack: () => void;
  buttonText?: string;
  backgroundColor?: string;
  draftPress?: () => void;
  draft?: boolean;
  progress?: number;
  progressScore?: string | number;
  isSubmitting?: boolean;
}

const BottomButton: React.FC<BottomButtonProps> = ({
  pressCallBack,
  buttonText = "SUBMIT",
  backgroundColor,
  draftPress,
  draft = false,
  progress = 0,
  progressScore = "",
  isSubmitting = false,
}) => {
  const [active, setActive] = useState(false);
  const bgColor = backgroundColor || "#C1AD84";

  if (draft) {
    return (
      <View style={styles.draftContainer}>
        {/* Floating Progress Button */}
        <TouchableOpacity
          style={styles.progressCircleContainer}
          onPress={() => setActive(!active)}
        >
          <Progress.Circle
            unfilledColor={Colors.appBackgroundColor}
            color={Colors.buttonColor}
            fill="white"
            textStyle={{ fontSize: 14, fontWeight: "bold" }}
            showsText
            size={70}
            progress={progress}
            formatText={() => String(progressScore)}
            thickness={5}
          />
        </TouchableOpacity>

        {!active && (
          <TouchableOpacity
            disabled={isSubmitting}
            style={styles.submitButton}
            onPress={pressCallBack}
          >
            <Text style={styles.submitText}>SUBMIT</Text>
          </TouchableOpacity>
        )}

        {!active && draftPress && (
          <TouchableOpacity style={styles.saveButton} onPress={draftPress}>
            <Text style={styles.saveText}>SAVE</Text>
          </TouchableOpacity>
        )}
      </View>
    );
  }

  return (
    <View style={{ flexDirection: "row", marginBottom: 0 }}>
      <TouchableOpacity
        disabled={isSubmitting}
        style={[styles.container, { backgroundColor: bgColor, justifyContent: "flex-end", marginLeft: 0, borderRadius: 0 }]}
        onPress={pressCallBack}
      >
        <Text style={styles.buttonText}>{buttonText}</Text>
      </TouchableOpacity>
    </View>
  );
};

export { BottomButton };

const styles = StyleSheet.create({
  container: {
    flexDirection: "row",
    height: 50,
    alignContent: "center",
    padding: 8,
    flex: 1,
  },
  draftContainer: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "center",
    position: "absolute",
    bottom: 10,
    left: 4,
    right: 10,
    backgroundColor: "transparent",
  },
  progressCircleContainer: {
    width: 70,
    height: 70,
    borderRadius: 35,
    backgroundColor: "#CCFF0000",
    alignItems: "center",
    justifyContent: "center",
  },
  submitButton: {
    shadowColor: "#000",
    shadowOffset: { width: 0, height: 4 },
    shadowOpacity: 0.3,
    shadowRadius: 4.65,
    borderRadius: width / 5,
    height: 40,
    elevation: 8,
    backgroundColor: "#C1AD84",
    width: width / 2 - 70,
    marginLeft: 100,
    marginRight: 20,
    marginBottom: 25,
    alignItems: "center",
    justifyContent: "center",
  },
  saveButton: {
    backgroundColor: "white",
    width: width / 2 - 70,
    borderWidth: 1,
    borderColor: "#C1AD84",
    borderRadius: width / 5,
    height: 40,
    marginRight: 20,
    shadowColor: "#000",
    shadowOffset: { width: 0, height: 4 },
    shadowOpacity: 0.3,
    shadowRadius: 4.65,
    elevation: 8,
    marginBottom: 25,
    alignItems: "center",
    justifyContent: "center",
  },
  submitText: { color: "white", fontSize: 14, padding: 4, fontWeight: "400", paddingLeft: 10 },
  saveText: { color: "#C1AD84", fontSize: 14, padding: 4, fontWeight: "400", paddingLeft: 10 },
  buttonText: { fontSize: 20, color: "white", alignSelf: "center", fontWeight: "700", marginRight: 10 },
});
