import React from 'react';
import { StyleSheet, TextStyle } from 'react-native';
import Spinner from 'react-native-loading-spinner-overlay';
import * as Progress from 'react-native-progress';

interface OverlaySpinnerProps {
  visible: boolean;
  textContent?: string;
  customIndicator?: boolean;
  progress?: number; // 0 to 1
}

const OverlaySpinner: React.FC<OverlaySpinnerProps> = ({
  visible,
  textContent = 'Loading...',
  customIndicator = false,
  progress = 0,
}) => {
  const renderCustomIndicator = () => {
    if (!customIndicator) return null;

    return (
      <Progress.Circle
        size={100}
        progress={progress}
        animated
        thickness={15}
        showsText
        indeterminate={progress === 0}
        formatText={(p) => `${Math.round(progress * 100)}%`}
      />
    );
  };

  return (
    <Spinner
      visible={visible}
      textContent={textContent}
      textStyle={styles.spinnerTextStyle}
      customIndicator={renderCustomIndicator()}
    />
  );
};

const styles = StyleSheet.create({
  spinnerTextStyle: {
    color: '#FFF',
    fontSize: 16,
  } as TextStyle,
});

export { OverlaySpinner };
