import React from 'react';
import { StyleSheet, Text, TextStyle, TouchableOpacity, ViewStyle } from 'react-native';

interface ButtonProps {
  title: string;
  backgroundColor?: string;
  textColor?: string;
  style?: ViewStyle | ViewStyle[];
  textStyle?: TextStyle | TextStyle[];
  onPress?: () => void;
  disabled?: boolean;
  defaultFont?: TextStyle | TextStyle[];
}

const Button: React.FC<ButtonProps> = ({
  title,
  backgroundColor = '#2196F3',
  textColor = '#fff',
  style,
  textStyle,
  onPress,
  disabled = false,
  defaultFont,
}) => {
  return (
    <TouchableOpacity
      activeOpacity={0.7}
      disabled={disabled}
      onPress={onPress}
      style={[
        styles.button,
        {
          backgroundColor: disabled ? 'gray' : backgroundColor,
          alignSelf: 'center',
          borderRadius: 25,
        },
        style, // only ViewStyle here
      ]}
    >
      <Text
        style={[
          styles.buttonText,
          defaultFont, // applied safely to Text
          { color: textColor },
          textStyle,
        ]}
      >
        {title}
      </Text>
    </TouchableOpacity>
  );
};

const styles = StyleSheet.create({
  button: {
    height: 45,
    paddingHorizontal: 16,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  } as ViewStyle,
  buttonText: {
    fontSize: 16,
    fontWeight: 'bold',
  } as TextStyle,
});

export default Button;
