import { MaterialCommunityIcons as Icon } from '@expo/vector-icons';
import React from 'react';
import { GestureResponderEvent, StyleSheet, Text, TouchableOpacity } from 'react-native';

interface TagItemProps {
  tagName: string;
  onRemoveTag: (event: GestureResponderEvent) => void;
}

const TagItem: React.FC<TagItemProps> = ({ tagName, onRemoveTag }) => {
  return (
    <TouchableOpacity onPress={onRemoveTag} style={styles.container}>
      <Icon name="close" size={14} color="#333" />
      <Text style={styles.text}>{tagName}</Text>
    </TouchableOpacity>
  );
};

const styles = StyleSheet.create({
  container: {
    paddingVertical: 4,
    paddingHorizontal: 8,
    flexDirection: 'row',
    alignItems: 'center',
    backgroundColor: '#f5f6f5',
    borderWidth: 1,
    borderColor: '#e9e9e9',
    margin: 4,
    borderRadius: 3,
  },
  text: {
    fontSize: 14,
    color: '#333',
    paddingLeft: 4,
  },
});

export default TagItem;
