import React from 'react';
import { StyleProp, TextInput, TextInputProps, TextStyle } from 'react-native';
import Colors from '../../constants/colors';

interface FormikTextInputProps extends TextInputProps {
  item: { questionId: string };
  name: string;
  value: string;
  handleBlur: (field: string) => void;
  handleChange: (field: string) => (text: string) => void;
  style?: StyleProp<TextStyle>;
  disabled?: boolean;
  placeholder?: string;
}

const FormikTextInput: React.FC<FormikTextInputProps> = ({
  item,
  name,
  value,
  handleBlur,
  handleChange,
  style,
  disabled = false,
  placeholder,
  ...rest
}) => {
  return (
    <TextInput
      editable={!disabled}
      placeholder={placeholder}
      placeholderTextColor={Colors.textColor}
      value={value}
      onBlur={() => handleBlur(`${item.questionId}_observation`)}
      onChangeText={handleChange(`${item.questionId}_observation`)}
      style={style}
      {...rest}
    />
  );
};

export { FormikTextInput };
