import { AnyAction } from "redux";
import { ThunkAction } from "redux-thunk";
import { RootState } from "../store";
import { REMOVE_FAILED_JOB } from "./types";

type AppThunk<ReturnType = void> = ThunkAction<
  ReturnType,
  RootState,
  unknown,
  AnyAction
>;

/**
 * ✅ Remove failed job by ID
 */
export const removeFailedJobById =
  (id: string): AppThunk =>
  (dispatch) => {
    dispatch({
      type: REMOVE_FAILED_JOB,
      payload: { id },
    });
  };
