import React from "react";
import { Image, ImageSourcePropType, StyleSheet, Text, View } from "react-native";
import Colors from '../../constants/colors';


interface BannerProps {
  image: ImageSourcePropType;
  title?: string;
  isGroup?: boolean;
  location?: string;
  form?: string;
  type?: string;
  marginVertical?: number;
}

const Banner: React.FC<BannerProps> = ({
  image,
  title,
  isGroup = false,
  location,
  form,
  type,
  marginVertical = 0,
}) => {
  return (
    <View style={[styles.container, { marginVertical }]}>
      <Image source={image} style={styles.logo} />
      {isGroup ? (
        <View style={styles.groupInfo}>
          <Text style={styles.label}>LOCATION :</Text>
          <Text style={styles.value}>{location}</Text>
          <Text style={styles.label}>{type} :</Text>
          <Text style={styles.value}>{form}</Text>
        </View>
      ) : (
        <View style={{ flex: 1 }}>
          <Text style={styles.title}>{title}</Text>
        </View>
      )}
    </View>
  );
};

export { Banner };

const styles = StyleSheet.create({
  container: {
    backgroundColor: Colors.colorWhite,
    flexDirection: 'row',
    alignItems: 'center',
    borderRadius: 10,
    padding: 8,
    paddingLeft: 12,
    marginBottom: 20,
    marginTop: 20,
  },
  logo: {
    resizeMode: 'contain',
    height: 70,
    width: 70,
    margin: 8,
  },
  groupInfo: {
    marginLeft: 15,
    flex: 1,
    justifyContent: 'center',
  },
  label: {
    fontSize: 14,
    color: Colors.colorTextInput,
  },
  value: {
    fontSize: 14,
    color: Colors.selectedColorSelect2,
  },
  title: {
    fontSize: 24,
    color: Colors.colorTextInput,
    textAlign: 'left',
    fontWeight: '200',
    marginHorizontal: 10,
  },
});
