import React from 'react';
import { Dimensions, Image, ImageSourcePropType, StyleSheet, Text, TouchableOpacity, View } from 'react-native';
import Colors from '../../constants/colors';

const { width } = Dimensions.get('window');
const tileHeight = width / 2 - 30;

interface TileProps {
  title: string;
  onSelectPress: () => void;
}

const Tile: React.FC<TileProps> = ({ title, onSelectPress }) => {
  let image: ImageSourcePropType = require('@/assets/images/permit.png');
  let titleText = title === 'Permit' ? 'CONTRACTORS & SUPPLIERS MANAGEMENT' : title;

  switch (title) {
    case 'CheckList':
      image = require('@/assets/images/checklist.png');
      titleText = 'OPERATIONAL & TECHNICAL CHECKLIST';
      break;
    case 'Inspection':
      image = require('@/assets/images/inspection.png');
      titleText = 'INSPECTION SYSTEM';
      break;
    case 'Auditing':
      image = require('../../assets/images/audits.png');
      titleText = 'AUDIT SYSTEM';
      break;
    case 'Suggestions':
      image = require('../../assets/images/suggestions.png');
      break;
    case 'IncidentReport':
      image = require('../../assets/images/incidents.png');
      titleText = 'INCIDENT REPORTING';
      break;
  }

  return (
    <View style={styles.gridItem}>
      <TouchableOpacity style={styles.container} onPress={onSelectPress}>
        <Image source={image} style={styles.logo} />
        <Text style={styles.text}>{titleText}</Text>
      </TouchableOpacity>
    </View>
  );
};

const styles = StyleSheet.create({
  gridItem: {
    flex: 1,
    margin: 15,
    height: tileHeight,
    shadowColor: 'rgba(0,0,0,0.38)',
    shadowOffset: { width: 0, height: 6 },
    shadowOpacity: 0.37,
    shadowRadius: 7.49,
    elevation: 12,
    marginTop: 8,
    marginBottom: 8,
    alignItems: 'center',
    justifyContent: 'center',
  },
  container: {
    flex: 1,
    shadowColor: 'rgba(0,0,0,0.38)',
    shadowOffset: { width: 0, height: 6 },
    shadowOpacity: 0.22,
    shadowRadius: 2.22,
    elevation: 3,
    padding: 15,
    justifyContent: 'center',
    alignItems: 'center',
    width: tileHeight,
    height: tileHeight,
    borderRadius: tileHeight / 2,
    backgroundColor: Colors.colorWhite,
    borderColor: 'rgba(0,0,0,0.17)',
    borderWidth: 1,
  },
  text: {
    color: Colors.colorTextInput,
    fontSize: 14,
    fontWeight: 'bold',
    textAlign: 'center',
    marginTop: 5,
  },
  logo: {
    resizeMode: 'contain',
    height: width / 11,
    width: width / 11,
  },
});

export { Tile };
