import React, { useState } from 'react'
import {
    Dimensions,
    Image,
    ImageBackground,
    ScrollView,
    StyleSheet,
    Text,
    View
} from 'react-native'
import { ListComponent } from '../../components/common'
import Colors from '../../constants/colors'
import CommonStyles from '../../constants/CommonStyles'
import Select2 from '../common/Select2'

const { height } = Dimensions.get('window')

export interface SelectionFormProps {
  auditForms: any[]
  entities: any[]
  selectedEntity: any
  setLocation: (data: any) => void
  setForm: (data: any, item: any) => void
  draftsList: any[]
  onDelete: (id: any) => void
  navigation: any
  listComponentNavigation: 'AuditFormScreen' | 'CheckListFormScreen' | 'InspectionFormScreen'
  title: string
  image: any
  isPermission: boolean
  setType: (data: any) => void
  checkListType: any[]
  buMangerList: any[]
  setBUManager: (data: any) => void
}

export const SelectionForm: React.FC<SelectionFormProps> = ({
  auditForms,
  entities,
  selectedEntity,
  setLocation,
  setForm,
  draftsList,
  onDelete,
  navigation,
  listComponentNavigation,
  title,
  image,
  isPermission,
  setType,
  checkListType,
  buMangerList,
  setBUManager
}) => {
  const [draft, setDraft] = useState<boolean>(false)

  return (
    <View style={{ flex: 1 }}>
      {draft ? (
        <View style={styles.listComponent}>
          {draftsList.length > 0 ? (
            <Text style={{ color: Colors.colorTextInput, margin: 10, fontSize: 14 }}>Drafts</Text>
          ) : null}
          <ScrollView>
            <ListComponent
              data={draftsList || []}
              onDelete={onDelete}
              listClick={(
                form_id,
                id,
                technical_form_id,
                operational_form_id,
                selectedEntity,
                selectedGroup,
                type,
                checklistSubmissionId,
                selectedBUManager
              ) => {
                switch (listComponentNavigation) {
                  case 'AuditFormScreen':
                    navigation.navigate(listComponentNavigation, {
                      auditFormId: form_id,
                      selectedEntity,
                      auditTypeId: id,
                      selectedGroup,
                      type,
                      selectedBUManager
                    })
                    break
                  case 'CheckListFormScreen':
                    navigation.navigate(listComponentNavigation, {
                      operational_form_id: form_id,
                      technical_form_id: form_id,
                      selectedEntity,
                      checkListTypeId: id,
                      selectedGroup,
                      checkListType: type,
                      checklistSubmissionId,
                      selectedBUManager
                    })
                    break
                  case 'InspectionFormScreen':
                    navigation.navigate(listComponentNavigation, {
                      inspectionFormId: form_id,
                      selectedEntity,
                      inspectionTypeId: id,
                      selectedGroup,
                      selectedBUManager
                    })
                    break
                }
              }}
            />
          </ScrollView>
        </View>
      ) : (
        <ImageBackground source={require('../../assets/images/cover.png')} style={styles.image}>
          <View style={styles.container}>
            <Image source={image} style={styles.logo} />
            <Text style={styles.title}>{title}</Text>
            {draftsList.length > 0 && (
              <Text style={styles.draft} onPress={() => setDraft(true)}>
                YOUR DRAFTS
              </Text>
            )}
          </View>
        </ImageBackground>
      )}
      <ScrollView>
        <View style={{ backgroundColor: Colors.appBackgroundColor, flex: 1, paddingTop: 20, paddingHorizontal: 20 }}>
          {isPermission && (
            <>
              <Text style={styles.subTitle}> Checklist Type </Text>
              <Select2
                isSelectSingle
                title="Select Checklist"
                colorTheme="#b69b30"
                popupTitle="Select Checklist"
                showSearchBox={false}
                cancelButtonText="Cancel"
                selectButtonText="OK"
                buttonTextStyle={{ fontSize: 11 }}
                listEmptyTitle="Options Empty"
                selectedTitleStyle={{ color: Colors.selectedColorSelect2 }}
                selectedPlaceholderTextColor={{ color: Colors.colorPlaceholder }} // fixed type
                style={CommonStyles.textInput} // remove array brackets
                isEnable={checkListType.length > 1}
                data={checkListType || []}
                onSelect={(data: any) => data.length > 0 && setType(data)}
                onRemoveItem={() => {}}
              />
            </>
          )}

          <Text style={styles.subTitle}> Location </Text>
          <Select2
            isSelectSingle
            title="Select Location"
            colorTheme="#b69b30"
            popupTitle="Select Location"
            cancelButtonText="Cancel"
            selectButtonText="OK"
            buttonTextStyle={{ fontSize: 11 }}
            listEmptyTitle="Options Empty"
            searchPlaceHolderText="Search.."
            selectedTitleStyle={{ color: Colors.selectedColorSelect2 }}
              selectedPlaceholderTextColor={{ color: Colors.colorPlaceholder }} // fixed type
            style={CommonStyles.textInput} // remove array brackets
            data={entities || []}
            onSelect={(data: any) => setLocation(data)}
            onRemoveItem={() => {}}
          />

          {selectedEntity && (
            <View style={{ marginTop: 5 }}>
              <Text style={styles.subTitle}> BU Manager </Text>
              <Select2
                isSelectSingle
                title="Select BU Manager"
                colorTheme="#b69b30"
                popupTitle="Select BU Manager"
                cancelButtonText="Cancel"
                selectButtonText="OK"
                buttonTextStyle={{ fontSize: 11 }}
                listEmptyTitle="Options Empty"
                searchPlaceHolderText="Search.."
                selectedTitleStyle={{ color: Colors.selectedColorSelect2 }}
              selectedPlaceholderTextColor={{ color: Colors.colorPlaceholder }} // fixed type
                style={CommonStyles.textInput} // remove array brackets
                data={buMangerList || []}
                onSelect={(data: any) => setBUManager(data)}
                onRemoveItem={() => {}}
              />

              <Text style={styles.subTitle}> {title} Forms </Text>
              <Select2
                isSelectSingle
                title="Select Form"
                colorTheme="#b69b30"
                popupTitle="Select Form"
                cancelButtonText="Cancel"
                selectButtonText="OK"
                buttonTextStyle={{ fontSize: 11 }}
                listEmptyTitle="Options Empty"
                searchPlaceHolderText="Search.."
                selectedTitleStyle={{ color: Colors.selectedColorSelect2 }}
                selectedPlaceholderTextColor={{ color: Colors.colorPlaceholder }} // fixed type
                style={CommonStyles.textInput} // remove array brackets
                data={auditForms || []}
                onSelect={(_: any, item: any) => item.length > 0 && setForm(_, item)}
                onRemoveItem={() => {}}
              />
            </View>
          )}
        </View>
      </ScrollView>
    </View>
  )
}

const styles = StyleSheet.create({
  image: {
    height: height / 1.8,
    resizeMode: 'stretch',
    justifyContent: 'flex-end'
  },
  listComponent: {
    height: height / 1.8,
    backgroundColor: Colors.colorWhite
  },
  text: {
    color: 'grey',
    fontSize: 30,
    fontWeight: 'bold'
  },
  container: {
    flexDirection: 'row',
    alignItems: 'center',
    alignSelf: 'baseline',
    backgroundColor: 'rgba(100, 100, 100, 0.5)'
  },
  logo: {
    resizeMode: 'contain',
    height: 54,
    width: 54,
    margin: 12
  },
  title: {
    fontSize: 24,
    color: Colors.colorWhite,
    fontWeight: '200',
    marginRight: 10,
    marginLeft: 10,
    flex: 2
  },
  draft: {
    alignSelf: 'flex-end',
    color: Colors.colorWhite,
    fontSize: 12,
    paddingRight: 10,
    paddingBottom: 10
  },
  subTitle: {
    color: Colors.colorTextInput,
    marginTop: 15,
    textAlign: 'left',
    fontSize: 12
  }
})
