import { combineReducers } from 'redux'
import { auditFormData, auditSubmitData } from './auditFormScreenReducer'
import { checkListFormData, checkListSubmissions, checklistSubmitData } from './checkListReducer'
import { failedJobsData } from './failedJobsReducer'
import { historyData } from './historyReducer'
import { permissions } from './homescreenReducer'
import incidentReportReducer from './incidentReportReducer'
import { initData } from './initDataReducer'
import { inspectionFormData, inspectionSubmitData } from './inspectionReducer'
import { notificationData } from './notificationScreenReducer'
import { permitFormData, permitSubmitData } from './permitReducer'
import { draftAnswerData } from './questionReducer'
import securityReducer from './securityReducer'

// 👇 define rootReducer once and export it
const rootReducer = combineReducers({
  userInfo: securityReducer,
  permissions,
  incidentReport: incidentReportReducer,
  auditFormData,
  auditSubmitData,
  inspectionFormData,
  inspectionSubmitData,
  checkListFormData,
  checkListSubmissions,
  checklistSubmitData,
  draftAnswerData,
  initData,
  permitFormData,
  permitSubmitData,
  notificationData,
  failedJobsData,
  historyData,
})

// 👇 automatically infer RootState type from rootReducer
export type RootState = ReturnType<typeof rootReducer>


export default rootReducer
