import React from 'react';
import { ActivityIndicator, ActivityIndicatorProps, StyleSheet, View } from 'react-native';

interface SpinnerProps {
  size?: ActivityIndicatorProps['size']; // 'small' | 'large' | number
}

const Spinner: React.FC<SpinnerProps> = ({ size = 'large' }) => {
  return (
    <View style={styles.spinnerStyle}>
      <ActivityIndicator size={size} />
    </View>
  );
};

const styles = StyleSheet.create({
  spinnerStyle: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
  },
});

export { Spinner };
