import { AntDesign as Icon } from '@expo/vector-icons';
import React, { useState } from 'react';
import {
    Image,
    SafeAreaView,
    StyleSheet,
    Text,
    TouchableOpacity,
    View,
} from 'react-native';
import Modal from 'react-native-modal';
import Colors from '../../constants/colors';
import { ArrayComponent } from '../common';

interface FormikImagePickerProps {
  field: { name: string; value?: any[] };
  setFieldValue: (field: string, value: any) => void;
  value?: any[];
  type: 'image' | 'video' | 'docs';
}

const FormikImagePicker: React.FC<FormikImagePickerProps> = ({
  field,
  setFieldValue,
  value = [],
  type,
}) => {
  const [isModalVisible, setModalVisible] = useState(false);

  const getImageAndTitle = (docType: FormikImagePickerProps['type']) => {
    switch (docType) {
      case 'image':
        return { image: require('@/assets/images/camera.png'), title: 'Image' };
      case 'video':
        return { image: require('@/assets/images/video.png'), title: 'Video' };
      case 'docs':
        return { image: require('@/assets/images/upload_file.png'), title: 'File' };
      default:
        return { image: require('@/assets/images/camera.png'), title: 'Attach' };
    }
  };

  const { image, title } = getImageAndTitle(type);

  return (
    <>
      <TouchableOpacity
        style={styles.attach}
        onPress={() => setModalVisible(true)}
      >
        <Text style={styles.attachText}>{title}</Text>
        <Image source={image} style={styles.logo} />
      </TouchableOpacity>

      <SafeAreaView>
        <Modal
          isVisible={isModalVisible}
          onBackButtonPress={() => setModalVisible(false)}
          onBackdropPress={() => setModalVisible(false)}
        >
          <View style={styles.content}>
            <Icon
              name="close-circle" // updated icon name
              size={24}
              color={Colors.colorPlaceholder}
              style={styles.closeIcon}
              onPress={() => setModalVisible(false)}
            />

            <ArrayComponent
              value={value}
              type={type}
              updateFormikData={(data) => {
                setFieldValue(field.name, data);
                setModalVisible(false);
              }}
            />
          </View>
        </Modal>
      </SafeAreaView>
    </>
  );
};

const styles = StyleSheet.create({
  content: {
    backgroundColor: 'white',
    padding: 16,
    borderRadius: 8,
    alignItems: 'center',
  },
  closeIcon: {
    alignSelf: 'flex-end',
    marginBottom: 12,
  },
  logo: {
    width: 24,
    height: 24,
    resizeMode: 'contain',
    marginLeft: 8,
    tintColor: '#fff',
  },
  attach: {
    flexDirection: 'row',
    alignItems: 'center',
    width: '25%',
    borderRadius: 8,
    justifyContent: 'center',
    paddingVertical: 6,
    paddingHorizontal: 8,
    backgroundColor: Colors.colorTextInput,
  },
  attachText: {
    color: '#fff',
    fontSize: 14,
    fontWeight: '600',
  },
});

export { FormikImagePicker };
