
import { StyleSheet, TextStyle, ViewStyle } from 'react-native';
import Colors from './colors';
// Define a type for our styles object for better type-checking

type CommonStyleSheet = {
    screen: ViewStyle;
    select2: ViewStyle;
    item: ViewStyle;
    textInput: TextStyle;
    incidentField: TextStyle;
    errorTextStyle: TextStyle;
    subTitle: TextStyle;
};

const CommonStyles: CommonStyleSheet = StyleSheet.create({
    screen: {
        flex: 1,
        backgroundColor: Colors.appBackgroundColor
    },
    select2: {
        backgroundColor: Colors.colorTextField,
        marginTop: 10
    },
    item: {
        marginVertical: 10,
        backgroundColor:Colors.colorTextField,
        borderRadius:5,
        borderColor:Colors.colorTextField
    },
    textInput: {
        borderColor: Colors.colorTextField,
        borderRadius: 5,
        backgroundColor: Colors.colorTextField,
        paddingLeft: 15,
        borderWidth: .5,
        minHeight: 40,
        fontSize: 14,
        marginTop:12,
        color: Colors.colorTextInput
    },
    incidentField: {
        height: 40,
        borderColor: Colors.colorTextField,
        borderWidth: 1,
        paddingLeft: 10,
        marginVertical: 10,
        backgroundColor:Colors.colorTextField,
        color: Colors.colorTextInput
    },
    errorTextStyle: {
        fontSize: 12,
        textAlign: 'right',
        color: 'red',
        marginBottom: 3,
        marginTop: 3
      },
      subTitle:{
          margin:4,
          marginBottom:2,
          color:Colors.colorTextInput,
          fontSize:12
        }
});

export default CommonStyles;