/**
 * Root-level hello – points to the hello module for the full example.
 * The real reference is the module: GET /api/v1/hello and POST /api/v1/hello/job
 */

import type { FastifyInstance, FastifyRequest, FastifyReply } from 'fastify';

export async function helloRoutes(app: FastifyInstance): Promise<void> {
  app.get('/', async (_request: FastifyRequest, reply: FastifyReply) => {
    return reply.send({
      message: 'MAFGateway 2026',
      helloModule: 'GET /api/v1/hello – Hello + directory structure (reference example)',
      helloJob: 'POST /api/v1/hello/job – Enqueue a demo job (API → Kafka → Worker)',
      seeModule: 'apps/api/src/modules/hello/',
    });
  });

  app.get('/hello', async (_request: FastifyRequest, reply: FastifyReply) => {
    return reply.redirect('/api/v1/hello', 302);
  });
}
