/**
 * Placeholder metrics endpoint - integrate with prom-client or OpenTelemetry in production.
 */

import type { FastifyInstance, FastifyRequest, FastifyReply } from 'fastify';

export async function metricsRoutes(app: FastifyInstance): Promise<void> {
  app.get('/metrics', async (_request: FastifyRequest, reply: FastifyReply) => {
    reply.header('Content-Type', 'text/plain; charset=utf-8');
    return reply.send(
      '# MAFGateway 2026 metrics (placeholder)\n# Add prom-client or OpenTelemetry exporter here\nmafgateway_info{version="1.0.0"} 1\n'
    );
  });
}
