import type { AnalyticsAggregatePayload } from '@mafgateway/shared';
import type { Logger } from '@mafgateway/shared';

export async function analyticsAggregateHandler(
  payload: AnalyticsAggregatePayload,
  logger: Logger
): Promise<void> {
  logger.info(
    { period: payload.period, dimensions: payload.dimensions },
    'Aggregating analytics (simulated)'
  );
  await new Promise((r) => setTimeout(r, 300));
  logger.info({ jobId: payload.jobId }, 'Analytics aggregation complete');
}
