/** @mafgateway/shared – types, config, logger, Kafka, Producer Service, Result Store */

export * from './types.js';
export * from './config.js';
export * from './logger.js';
export * from './broker.js';
export { createProducerService, type ProducerService } from './producer-service.js';
export {
  createDefaultResultStore,
  InMemoryResultStore,
  FileResultStore,
  type ResultStore,
  type JobResult,
} from './result-store.js';
export type { Logger } from 'pino';
export { createKafkaJobClient, KafkaJobClient, type KafkaClientConfig } from './kafka.js';
export { createQueueConsumer, type QueueConsumer, type QueueConsumerConfig } from './queue-consumer.js';
