/**
 * Producer Service Layer – single entry point for enqueueing jobs to the message broker.
 * Used by API Gateway; never produces directly from route handlers.
 */

import type { JobPayload } from './types.js';
import type { KafkaJobClient } from './kafka.js';
import { childLogger } from './logger.js';

const logger = childLogger({ module: 'producer-service' });

export interface ProducerService {
  enqueue(job: JobPayload, key?: string): Promise<void>;
}

export function createProducerService(client: KafkaJobClient): ProducerService {
  return {
    async enqueue(job: JobPayload, key?: string): Promise<void> {
      await client.publishJob(job, key);
      logger.debug({ jobId: job.jobId, jobType: job.jobType }, 'ProducerService: job enqueued');
    },
  };
}
