/**
 * API Gateway / Load Balancer layer – single entry for all client traffic.
 * Handles: request id, logging, and forwards to routes → Producer Service (for jobs).
 */

import type { FastifyInstance, FastifyRequest, FastifyReply } from 'fastify';
import { childLogger } from '@mafgateway/shared';

export async function registerGateway(app: FastifyInstance): Promise<void> {
  const log = childLogger({ module: 'gateway' });

  app.addHook('onRequest', async (request: FastifyRequest, _reply: FastifyReply) => {
    const req = request as FastifyRequest & { requestId?: string };
    req.requestId = (request.headers['x-request-id'] as string) ?? crypto.randomUUID();
    log.debug({ requestId: req.requestId, method: request.method, url: request.url }, 'Gateway: request');
  });
}
