import type { FastifyRequest, FastifyReply } from 'fastify';
import type { AppConfig, HealthCheckResult } from '@mafgateway/shared';

export function healthRoutes(config: AppConfig) {
  return async function handler(
    _request: FastifyRequest<{ Querystring: { deep?: string } }>,
    reply: FastifyReply
  ) {
    const deep = _request.query?.deep === 'true';
    const result: { status: string; env: string; checks?: HealthCheckResult[] } = {
      status: 'ok',
      env: config.env,
    };
    if (deep) {
      result.checks = [];
      // Placeholder for module health checks when they register
    }
    return reply.send(result);
  };
}
