/**
 * Central route registration – add new core routes here to keep index.ts minimal.
 */

import type { FastifyInstance } from 'fastify';
import type { AppConfig } from '@mafgateway/shared';
import { healthRoutes } from './health.js';
import { helloRoutes } from './hello.js';
import { registerJobRoutes } from './jobs.js';
import { metricsRoutes } from './metrics.js';

export async function registerRoutes(app: FastifyInstance, config: AppConfig): Promise<void> {
  app.get('/health', healthRoutes(config));
  await helloRoutes(app);
  await registerJobRoutes(app);
  await metricsRoutes(app);
}
