/**
 * Handler for hello.demo jobs – enqueued by the hello module (POST /api/v1/hello/job).
 */

import type { HelloDemoPayload } from '@mafgateway/shared';
import type { Logger } from '@mafgateway/shared';

export async function helloDemoHandler(payload: HelloDemoPayload, logger: Logger): Promise<void> {
  logger.info(
    { jobId: payload.jobId, message: payload.message, requestId: payload.requestId },
    'Hello demo job processed (worker)'
  );
  // Simulate a small delay (e.g. sending email, calling external API)
  await new Promise((r) => setTimeout(r, 100));
  logger.info({ jobId: payload.jobId }, 'Hello demo job complete');
}
