import type { ReportGeneratePayload } from '@mafgateway/shared';
import type { Logger } from '@mafgateway/shared';

export async function reportGenerateHandler(
  payload: ReportGeneratePayload,
  logger: Logger
): Promise<void> {
  logger.info(
    { reportType: payload.reportType, params: payload.params },
    'Generating report (simulated)'
  );
  await new Promise((r) => setTimeout(r, 500));
  logger.info({ jobId: payload.jobId }, 'Report generation complete');
}
