# MAFGateway 2026 – Architecture (simplified)

## Folder structure

```
MAF2.0/
├── apps/
│   ├── api/                    # HTTP API (modular monolith)
│   │   └── src/
│   │       ├── index.ts        # Bootstrap, plugins, route registration, module loader
│   │       ├── routes/         # Global routes (hello, health, jobs, metrics)
│   │       └── modules/        # Domain modules (one folder per domain)
│   │           ├── auth/
│   │           ├── permits/
│   │           ├── incidents/
│   │           ├── analytics/
│   │           └── notifications/
│   └── worker/                 # Background job processor (Kafka consumer)
│       └── src/
│           └── handlers/       # One file per job type
├── packages/
│   └── shared/                 # Single shared package
│       └── src/
│           ├── types.ts        # DTOs, job payloads, module contract
│           ├── config.ts       # loadConfig() from env
│           ├── logger.ts       # Pino logger
│           ├── kafka.ts         # Producer/consumer, retry, DLQ
│           └── index.ts
├── docs/
├── package.json
└── pnpm-workspace.yaml
```

## Why this is simpler

| Before | After |
|--------|--------|
| 4 packages: types, config, logger, kafka-client | 1 package: **shared** |
| Domain modules as separate workspace packages (`modules/auth`, etc.) with their own package.json, tsconfig, build | Domain modules as **folders** under `apps/api/src/modules/`; no extra build step, no workspace entries |
| Registry imported from `@mafgateway/module-auth` | Registry imports from `./auth/index.js` (local path) |

## Service boundaries

- **API** – Serves HTTP. Loads each domain module from `src/modules/<name>/index.ts` via `registry.ts`. Each module exports `{ name, register(app, ctx) }`.
- **Worker** – Consumes from Kafka topic `mafgateway.jobs`, dispatches by `jobType` to handlers. Retries with backoff; after max retries, sends to DLQ topic.
- **shared** – Used by both API and worker. No business logic; only types, config, logger, Kafka client.

## Extracting a module to a microservice

1. Copy `apps/api/src/modules/<name>/` (e.g. `auth`) into a new app or repo.
2. Copy or depend on `packages/shared` (or only the parts you need).
3. In the new app, expose the same HTTP routes.
4. In the monolith, remove the module from `registry.ts` and call the new service via HTTP/gRPC instead of `register()`.

Same API contract; only the call moves from in-process to network.

## Kafka and worker

- **Topics:** `mafgateway.jobs` (main), `mafgateway.jobs.dlq` (dead-letter).
- **Retry:** Up to 5 attempts, exponential backoff; then DLQ.
- **Scaling:** Run more worker instances; same consumer group shares partitions.

## Observability

- **Logging:** Pino via `@mafgateway/shared`; `requestId` and module context.
- **Health:** `GET /health`.
- **Metrics:** `GET /metrics` (placeholder; add Prometheus/OpenTelemetry as needed).
