# Install Kafka for local development

Use one of the options below so the API and Worker can use Kafka locally.

---

## Option 1: Docker (recommended)

If you have **Docker** and **Docker Compose** installed:

```bash
# From the project root (MAF2.0)
docker compose up -d zookeeper kafka
```

Kafka will listen on **localhost:9092**. Use in `.env`:

```bash
KAFKA_BROKERS=localhost:9092
```

To install Docker on Ubuntu:

```bash
sudo apt update
sudo apt install docker.io docker-compose-v2
# Add your user to the docker group to run without sudo:
sudo usermod -aG docker $USER
# Log out and back in, then:
docker compose up -d zookeeper kafka
```

---

## Option 2: Docker Compose (legacy command)

If you have the older `docker-compose` (with hyphen):

```bash
docker-compose up -d zookeeper kafka
```

---

## Option 3: Install Kafka on the host (no Docker)

Apache Kafka is installed under the project as **`.kafka/`** (ignored by git). If you need to reinstall or install on another machine:

```bash
# Java required (OpenJDK 17+)
java -version

# From project root (MAF2.0)
mkdir -p .kafka && cd .kafka
wget https://archive.apache.org/dist/kafka/3.6.2/kafka_2.13-3.6.2.tgz -O kafka.tgz
tar -xzf kafka.tgz && mv kafka_2.13-3.6.2 kafka && rm kafka.tgz
cd kafka

# Terminal 1: Zookeeper
bin/zookeeper-server-start.sh config/zookeeper.properties

# Terminal 2: Kafka
bin/kafka-server-start.sh config/server.properties
```

**Start/stop scripts (after install):**

```bash
./scripts/kafka-start.sh   # Start Zookeeper + Kafka in background
./scripts/kafka-stop.sh     # Stop both
```

Topics `mafgateway.jobs` and `mafgateway.jobs.dlq` are created automatically when the app first uses them, or create them once:

```bash
cd .kafka/kafka
bin/kafka-topics.sh --create --topic mafgateway.jobs --bootstrap-server localhost:9092 --partitions 3 --replication-factor 1
bin/kafka-topics.sh --create --topic mafgateway.jobs.dlq --bootstrap-server localhost:9092 --partitions 1 --replication-factor 1
```

Then set in `.env`:

```bash
KAFKA_BROKERS=localhost:9092
```

---

## Verify

1. Copy `.env.example` to `.env` and set `KAFKA_BROKERS=localhost:9092`.
2. Start the API: `pnpm run dev:api`.
3. Start the Worker: `pnpm run dev:worker`.
4. Enqueue a job: `curl -X POST http://localhost:3000/api/v1/hello/job -H "Content-Type: application/json" -d '{}'`.
5. Check the Worker terminal for a log line like “Hello demo job processed”.

---

## Stop Kafka (Docker)

```bash
docker compose down
# Or: docker-compose down
```
