# Queue system architecture

```
Clients / APIs
      │
      ▼
API Gateway / Load Balancer     ← Fastify API (gateway.ts: request id, logging)
      │
      ▼
Producer Service Layer          ← producerService.enqueue(job); single path to broker
      │
      ▼
Message Broker (Kafka)          ← topics: mafgateway.jobs, mafgateway.jobs.dlq
      │
      ├──────────────────┬──────────────────┬──────────────────┐
      ▼                  ▼                  ▼                  ▼
Worker Pool          Stream Processors   (failed after      Dead Letter Queue
(heavy tasks)        (e.g. analytics)     retries)          (DLQ topic)
      │                  │                                      │
      ▼                  ▼                                      ▼
ResultStore           ResultStore                         DLQ Processor
(DB/Cache/Storage)    (DB/Cache/Storage)                   → ResultStore / alert
```

## Components

| Layer | Implementation |
|-------|----------------|
| **API Gateway** | `apps/api`: Fastify + gateway.ts (onRequest: requestId, logging). Single entry for clients. |
| **Producer Service** | `packages/shared/producer-service.ts`. All enqueue goes through `producerService.enqueue(job)`. API and modules use this only. |
| **Message Broker** | Kafka. Channels: `mafgateway.jobs` (main queue), `mafgateway.jobs.dlq` (dead letter). |
| **Worker Pool** | `apps/worker`: main consumer (group `mafgateway-workers`). Handles hello.demo, report.generate, file.process, etc. Retry + DLQ on failure. Writes to ResultStore. |
| **Stream Processors** | Same topic, group `mafgateway-stream-processors`. Handles stream-type jobs (e.g. analytics.aggregate). Writes to ResultStore. |
| **Dead Letter Queue** | Failed jobs (after max retries) are produced to `mafgateway.jobs.dlq`. |
| **DLQ Processor** | Consumer on DLQ topic (group `mafgateway-dlq-processors`). Logs and persists to ResultStore for inspection/replay. |
| **ResultStore** | Sink for completed/failed results. Default: InMemoryResultStore; can use FileResultStore or DB. |

## Env (worker)

- `KAFKA_CONSUMER_GROUP` – Worker Pool group (default `mafgateway-workers`).
- `KAFKA_STREAM_GROUP` – Stream Processors group (default `mafgateway-stream-processors`).
- `KAFKA_DLQ_GROUP` – DLQ Processor group (default `mafgateway-dlq-processors`).

## Flow

1. Client → **API Gateway** → route or module calls **Producer Service** `enqueue(job)`.
2. **Producer Service** → produces to Kafka topic `mafgateway.jobs`.
3. **Worker Pool** and **Stream Processors** consume from `mafgateway.jobs` (different groups).
   - Pool: handles most job types; retries then sends to DLQ on final failure.
   - Stream: handles only stream types (e.g. analytics.aggregate).
4. **DLQ Processor** consumes from `mafgateway.jobs.dlq`, logs and stores for alerting/replay.
5. Workers and DLQ processor write results to **ResultStore** (Database / Cache / Storage).
