/**
 * Message Broker Layer – topic/channel definitions for Queue and Stream.
 * All producers and consumers use these channels.
 */

export const BROKER_CHANNELS = {
  /** Main job queue – Producer Service writes here; Worker Pool and Stream Processors read. */
  JOBS_QUEUE: 'mafgateway.jobs',
  /** Dead Letter Queue – failed jobs after max retries. DLQ Processor reads. */
  DLQ: 'mafgateway.jobs.dlq',
} as const;

export type BrokerChannel = (typeof BROKER_CHANNELS)[keyof typeof BROKER_CHANNELS];
