#!/usr/bin/env bash
# Start Zookeeper and Kafka (host install under .kafka/)
set -e
ROOT="$(cd "$(dirname "$0")/.." && pwd)"
KAFKA_DIR="$ROOT/.kafka/kafka"
if [[ ! -d "$KAFKA_DIR" ]]; then
  echo "Kafka not found at $KAFKA_DIR. Run docs/INSTALL-KAFKA.md Option 3 or install manually."
  exit 1
fi
cd "$KAFKA_DIR"
nohup bin/zookeeper-server-start.sh config/zookeeper.properties > "$ROOT/.kafka/zookeeper.log" 2>&1 &
echo $! > "$ROOT/.kafka/zookeeper.pid"
sleep 3
nohup bin/kafka-server-start.sh config/server.properties > "$ROOT/.kafka/kafka.log" 2>&1 &
echo $! > "$ROOT/.kafka/kafka.pid"
echo "Zookeeper and Kafka started. Logs: .kafka/zookeeper.log, .kafka/kafka.log"
echo "Broker: localhost:9092"
