#!/usr/bin/env bash
# Stop Kafka then Zookeeper (host install)
set -e
ROOT="$(cd "$(dirname "$0")/.." && pwd)"
PID_K="$ROOT/.kafka/kafka.pid"
PID_Z="$ROOT/.kafka/zookeeper.pid"
for label in kafka zookeeper; do
  if [[ "$label" == kafka ]]; then f="$PID_K"; else f="$PID_Z"; fi
  if [[ -f "$f" ]]; then
    pid=$(cat "$f")
    if kill -0 "$pid" 2>/dev/null; then
      kill "$pid" 2>/dev/null || true
      echo "Stopped $label (PID $pid)"
    fi
    rm -f "$f"
  fi
done
# Also kill any leftover java processes for kafka/zookeeper in this project
pkill -f "kafka.Kafka" 2>/dev/null || true
pkill -f "QuorumPeerMain" 2>/dev/null || true
echo "Kafka and Zookeeper stopped."
