var express = require('express');
const webhookCtrl = require("../controllers/webhook.controller");
const connectionCtrl = require("../controllers/connection.controller");
const messageCtrl = require("../controllers/message.controller");
const sentFileCtrl = require("../controllers/sentfile.controller");
const retriveCtrl = require("../controllers/retrive.controller");

var router = express.Router();
var multer = require('multer');

var storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, 'public/uploads')
  },
    filename: function (req, file, cb) {
    cb(null, file.fieldname + '-' + Date.now())
  }
});
var upload = multer({storage: storage});


router.get("/check", (req, res) => {
    res.send("OK");
});
  
/* GET home page. */
router.post('/webhook', webhookCtrl.saveResponse);
router.get('/create-connection/:mobile_number', connectionCtrl.createConnection);
router.post('/sent-message', messageCtrl.sentMessage);
router.post('/sent-files', upload.single('file'), sentFileCtrl.sentFiles);
router.post('/retrive', retriveCtrl.getAttachment);

module.exports = router;
