const {  ApiLogs } = require('../config/db.config');
var request = require('request');
const S3Upload = require("../helpers/s3-upload.helper");
const fs = require('fs');

async function sentFiles(req, res) {
    try {            
            let mobile_number = req.body.mobile_number;
            let identifier = req.body.identifier;
            let link;
            let location_name;
            req.body.link ? (link = req.body.link): (req.body.location_name ? (location_name = req.body.location_name) : "");
            let img = ['image/jpeg', 'image/png'];
            let doc = ['application/pdf', 'application/msword', 'application/vnd.ms-powerpoint','application/vnd.ms-excel', 'text/plain'];
            let audio = ['audio/aac', 'audio/mp4', 'audio/amr', 'audio/mpeg', 'audio/ogg', 'codecs=opus'];
            let video = ['video/mp4'];
            let dataString;
            let type;
            if (link) {
                dataString = '{"message": {"receivers":[{"name":"name","address":"​'+mobile_number+'","Connector":"​'+identifier+'", "type":"individual"}],"parts":[{"id":"1","contentType":"text/plain","data":"​'+link+'" ,"size": '+link.length+' ,"type":"link","sort":0}]}}';
                type = 'link';
            } else if(location_name) {
                dataString = '{"message": {"receivers":[{"name":"name","address":"​'+mobile_number+'","Connector":"​'+identifier+'", "type":"individual"}],"parts":[{"id":"1","contentType":"application/json","data":{ \"longitude\":'+req.body.longitude+', \"latitude\":'+req.body.latitude+', \"name\": \"​'+req.body.location_name+'\", \"address\": \"​'+req.body.address+' \"} ,"size":"'+req.body.address.length+'" ,"type":"location","sort":0}]}}'
                type = 'location';
            } else {
                let mimetype = req.file.mimetype;
                console.log(mimetype);
                console.log(audio.includes(mimetype));
                let base_path = `local/whatsapp_api/files/${req.file.filename}.${ mimetype.split("/")[1] }`;
                const fileContent = fs.readFileSync(req.file.path);
                let result = await S3Upload.s3Upload(fileContent, base_path, req.file.path);

                img.includes(mimetype) ? (type = 'image_link') : (doc.includes(mimetype) ? (type = 'file') : 
                (audio.includes(mimetype) ? (type = 'audio_link') : (video.includes(mimetype) ? (type = 'video_link') : "")));
                let img_caption;
                req.body.img_caption ? (img_caption = req.body.img_caption) : "";
                if (img_caption) {
                    dataString = '{"message": {"receivers":[{"name":"name","address":"​'+mobile_number+'","Connector":"'+identifier+'", "type":"individual"}],"parts":[{"id":"1","contentType":"text/plain","data":"​'+img_caption+'" ,"size":'+img_caption.length+',"type":"body","sort":0},{"id": "0", "contentType": "​'+mimetype+'" ,"size":'+result.path.length+',"type": "image_link","name":"​'+req.file.filename+'.'+mimetype.split("/")[1]+'","data":"​'+result.path+'","sort":1}]}}';
                } else {
                    dataString = '{"message": {"receivers":[{"name":"name","address":"'+mobile_number+'","Connector":"'+identifier+'", "type":"individual"}],"parts": [{"id": "0","contentType": "'+mimetype+'" ,"size":'+result.path.length+',"type": "'+type+'","name":"'+req.file.filename+'.'+mimetype.split("/")[1]+'","data":"'+result.path+'","sort":1}]}}';
                }
            }
            let options = {
                url: 'https://apiv2.unificationengine.com/v2/message/send',
                method: 'POST',
                body: dataString,
                auth: {
                    'user': 'a913b40f-aa55-49ef-ae23-bbd4d1baec94',
                    'pass': '025fd444-62b4-4c44-b097-28ef2bde4f6e'
                }
            };
            console.log(options)

            await request(options, function (error, response, body) {
              let respo = JSON.parse(body);
               console.log(respo);
               if (!error) {
                    if (respo.Status) {
                        ApiLogs.create({identifier: identifier, request: JSON.parse(dataString), response: respo, mobile_number: mobile_number, type:type, status:"sent"})
                        .then(user => res.send({error: false, message:respo}) )
                        .catch(function (err) {
                            console.log(err);
                            res.status(500).send({msg:"something went wrong!"});
                        });
                    } else res.status(500).send({error: true, message:respo});
               } else res.status(500).send({error: true, message:error});
            });

    } catch (err) {
        console.log(err);
        res.status(500).send({error: true, message:err});
    }
}
module.exports = {
    sentFiles
};  