module.exports = (sequelize, type) => {
    return sequelize.define('api_logs', {
        id: {
          type: type.INTEGER,
          primaryKey: true,
          autoIncrement: true
        },        
        request: type.JSON,
        response: type.JSON,
        mobile_number: type.STRING,
        type: type.STRING,
        status: type.STRING, 
        identifier: type.STRING,
        created_at: {
          type: 'TIMESTAMP',
          defaultValue: sequelize.literal('CURRENT_TIMESTAMP'),
          allowNull: false
        }
    })
}