import { FastifyPluginAsync } from 'fastify';
import { Sequelize } from 'sequelize-typescript';

const dbPlugin: FastifyPluginAsync = async (fastify) => {
  const sequelize = new Sequelize({
    database: 'product_db',
    username: 'root',
    password: 'Faruskhan@985',
    host: 'localhost',
    dialect: 'mysql',
    models: [__dirname + '/../models'], // Make sure this path is correct
  });

  try {
    await sequelize.sync();
    console.log('Sequelize connected successfully');

    // Optionally attach sequelize instance to Fastify
    fastify.decorate('sequelize', sequelize);
  } catch (err) {
    console.error('Error connecting to DB:', err);
  }
};

export default dbPlugin;
