import { FastifyPluginAsync } from 'fastify';
import { z } from 'zod';
import { User } from '../models/User';

const userSchema = z.object({
  name: z.string(),
  email: z.string().email()
});

const userRoutes: FastifyPluginAsync = async (fastify) => {
  fastify.post('/', async (req, res) => {
    const parsed = userSchema.safeParse(req.body);
    if (!parsed.success) {
      return res.status(400).send(parsed.error);
    }

    const user = await User.create(parsed.data);
    res.send(user);
  });
};

export default userRoutes;
