import Image from 'next/image';
import { LinkButton } from '@/components/base/LinkButton';

const HomePage = () => {
  return (
    <center className="py-10">
      <Image
        src="/img/nextjs.svg"
        alt="Next.js"
        width={512}
        height={103}
        className="w-60 mb-4"
      />
      <h3 className="text-3xl text-gray-600 font-semibold mb-5 px-5">
        Welcome to Next.js starter template
      </h3>
      <div className="bg-gray-100 p-5 mb-10">
        <p className="mb-3 text-gray-400 font-semibold">
          This template is built with
        </p>
        <div className="flex justify-center gap-5">
          <Image
            src="/img/tailwind.svg"
            alt="Tailwind CSS"
            width={512}
            height={63}
            className="w-40"
          />
          <Image
            src="/img/typescript.svg"
            alt="TypeScript"
            width={284}
            height={70}
            className="w-24"
          />
          <Image
            src="/img/hero-ui.svg"
            alt="HeroUI"
            width={180}
            height={180}
            className="w-24"
          />
        </div>
      </div>
      <LinkButton href="/another" color="primary" size="lg">
        Navigate to another page
      </LinkButton>
    </center>
  );
};

export default HomePage;
