import React from 'react';
import { themes } from '@storybook/theming';
import { HeroUIProvider } from "@heroui/react";

import './style.css';
import '@/styles/globals.css';

import type { Preview } from '@storybook/react';

const decorators: Preview['decorators'] = [
  (Story, { globals: { locale, disableAnimation } }) => {
    const direction =
      // @ts-ignore
      locale && new Intl.Locale(locale)?.textInfo?.direction === 'rtl'
        ? 'rtl'
        : undefined;

    return (
      <HeroUIProvider locale={locale} disableAnimation={disableAnimation}>
        <div className="bg-dark" lang={locale} dir={direction}>
          <Story />
        </div>
      </HeroUIProvider>
    );
  }
];

const parameters: Preview['parameters'] = {
  actions: { argTypesRegex: '^on[A-Z].*' },
  options: {
    storySort: {
      method: 'alphabetical',
      order: ['Foundations']
    }
  },
  controls: {
    matchers: {
      color: /(background|color)$/i,
      date: /Date$/i
    }
  },
  darkMode: {
    current: 'dark',
    stylePreview: true,
    darkClass: 'dark',
    lightClass: 'light',
    classTarget: 'html',
    dark: {
      ...themes.dark,
      appBg: '#161616',
      barBg: 'black',
      background: 'black',
      appContentBg: 'black',
      appBorderRadius: 14
    },
    light: {
      ...themes.light
    }
  }
};

const globalTypes: Preview['globalTypes'] = {
  locale: {
    toolbar: {
      icon: 'globe',
      items: ['en', 'ar'].map((locale) => ({
        value: locale,
        title: new Intl.DisplayNames(undefined, { type: 'language' }).of(
          locale
        ),
        right:
          // @ts-ignore
          new Intl.Locale(locale)?.textInfo?.direction === 'rtl'
            ? 'Right to Left'
            : undefined
      }))
    }
  },
  disableAnimation: {
    name: 'Disable Animation',
    description: 'Disable all animations in the stories',
    toolbar: {
      icon: 'photodrag',
      items: [
        { value: true, title: 'True' },
        { value: false, title: 'False' }
      ]
    }
  }
};

const preview: Preview = {
  decorators,
  parameters,
  globalTypes
};

export default preview;
