import type { Meta, StoryObj } from '@storybook/react';
import { Button } from "@heroui/button";

import type { ButtonProps } from "@heroui/button";

const meta: Meta<typeof Button> = {
  title: 'Basic/Button',
  component: Button,
  tags: ['autodocs']
};

export default meta;

type Story = StoryObj<typeof meta>;

type TemplateProps = {
  color: ButtonProps['color'];
};

const Template = ({ color }: TemplateProps) => {
  return (
    <div>
      <h6 className="mb-2 font-semibold">Size</h6>
      <div className="flex gap-5 mb-4 flex-wrap items-center">
        <Button color={color} size="sm">
          Small button
        </Button>
        <Button color={color} size="md">
          Medium button
        </Button>
        <Button color={color} size="lg">
          Large button
        </Button>
        <Button color={color} size="sm" variant="ghost">
          Small Outline
        </Button>
        <Button color={color} size="md" variant="ghost">
          Medium Outline
        </Button>
        <Button color={color} size="lg" variant="ghost">
          Large Outline
        </Button>
      </div>
      <h6 className="mb-2 font-semibold">Loading</h6>
      <div className="flex gap-5 mb-4 flex-wrap items-center">
        <Button color={color} size="sm" isLoading>
          Small button
        </Button>
        <Button color={color} size="md" isLoading>
          Medium button
        </Button>
        <Button color={color} size="lg" isLoading>
          Large button
        </Button>
        <Button color={color} size="sm" variant="ghost" isLoading>
          Small Outline
        </Button>
        <Button color={color} size="md" variant="ghost" isLoading>
          Medium Outline
        </Button>
        <Button color={color} size="lg" variant="ghost" isLoading>
          Large Outline
        </Button>
      </div>
      <h6 className="mb-2 font-semibold">Disabled</h6>
      <div className="flex gap-5 mb-4 flex-wrap items-center">
        <Button color={color} size="sm" isDisabled>
          Small button
        </Button>
        <Button color={color} size="md" isDisabled>
          Medium button
        </Button>
        <Button color={color} size="lg" isDisabled>
          Large button
        </Button>
        <Button color={color} size="sm" variant="ghost" isDisabled>
          Small Outline
        </Button>
        <Button color={color} size="md" variant="ghost" isDisabled>
          Medium Outline
        </Button>
        <Button color={color} size="lg" variant="ghost" isDisabled>
          Large Outline
        </Button>
      </div>
      <h6 className="mb-2 font-semibold">Full Width</h6>
      <div className="flex flex-col gap-5">
        <Button color={color} size="sm" fullWidth>
          Small button
        </Button>
        <Button color={color} size="md" fullWidth>
          Medium button
        </Button>
        <Button color={color} size="lg" fullWidth>
          Large button
        </Button>
        <Button color={color} size="sm" variant="ghost" fullWidth>
          Small Outline
        </Button>
        <Button color={color} size="md" variant="ghost" fullWidth>
          Medium Outline
        </Button>
        <Button color={color} size="lg" variant="ghost" fullWidth>
          Large Outline
        </Button>
      </div>
    </div>
  );
};

export const Default: Story = {
  render: () => <Template color="default" />
};
export const Primary: Story = {
  render: () => <Template color="primary" />
};
export const Secondary: Story = {
  render: () => <Template color="secondary" />
};
export const Success: Story = {
  render: () => <Template color="success" />
};
export const Warning: Story = {
  render: () => <Template color="warning" />
};
export const Danger: Story = {
  render: () => <Template color="danger" />
};
