import { heroui } from '@heroui/react';
import colors from './theme/colors';

import type { Config } from 'tailwindcss';

const config: Config = {
  content: [
    './pages/**/*.{js,ts,jsx,tsx,mdx}',
    './components/**/*.{js,ts,jsx,tsx,mdx}',
    './theme/**/*.{js,ts,jsx,tsx,mdx}',
    './app/**/*.{js,ts,jsx,tsx,mdx}',
    './node_modules/@heroui/theme/dist/**/*.{js,ts,jsx,tsx}'
  ],
  theme: {
    extend: {
      fontFamily: {
        sans: ['Indivisible', 'sans-serif']
      }
    }
  },
  darkMode: 'class',
  plugins: [
    heroui({
      themes: {
        light: colors.light,
        dark: colors.dark
      }
    })
  ]
};
export default config;
