import type { StorybookConfig } from '@storybook/nextjs';
import path from 'path';

const config: StorybookConfig = {
  stories: [
    '../components/**/*.stories.@(ts|tsx|js|jsx|mdx)',
    '../styles/**/*.stories.@(ts|tsx|js|jsx|mdx)'
  ],
  addons: ['@storybook/addon-links', '@storybook/addon-themes'],
  webpackFinal: async (config) => {
    if (config.resolve) {
      config.resolve.alias = {
        ...config.resolve.alias,
        '@': path.resolve(__dirname, '../')
      };
    }
    return config;
  },
  framework: {
    name: '@storybook/nextjs',
    options: {}
  }
};
export default config;
